package easik.sketch.util;

import java.util.Vector;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;

import easik.Easik;
import easik.sketch.Sketch;
import easik.sketch.constraint.Constraint;
import easik.sketch.edge.GuideEdge;
import easik.sketch.vertex.EntityNode;

/** 
 * This class sits on the Sketch we've created and listens for selection
 * events. Upon receiving them it updates a vector of currently
 * selected objects (JGraphT, not JGraph cells), and allows the application
 * to manipulate them.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-07-31 Kevin Green
 */
public class SketchSelectionListener implements GraphSelectionListener {
	/**
	 * The current selection as defined by the user
	 */
	Vector<Object> _currentSelection;
	/**
	 * The current sketch
	 */
	Sketch _ourSketch;	
	/**
	 * Initialises the sketch listener. Give it a pointer to the sketch it is resting on
	 * so it can check attributes.
	 * 
	 * @param inSketch Sketch it is watching
	 */
	public SketchSelectionListener(Sketch inSketch) {
		_ourSketch = inSketch;
		_currentSelection = new Vector<Object>();
	}

	/**
	 * Returns the vector containing the current selection
	 * @return Current selection in a vector 
	 */
	public Vector getCurrentSelection() {
		return _currentSelection;
	}

	/**
	 * Clears the selection buffer, should only ever be used when loading a new
	 * sketch or clearing an existing one.
	 *
	 */
	public void emptySelection() {
		_currentSelection.clear();	
	}

	/**
	 * Overloaded listener event. Whenever selection changes, this will update
	 * the contents of the selection vector
	 * @param graphEvent The event object
	 */
	public void valueChanged(GraphSelectionEvent graphEvent) {
		Object[] temp = graphEvent.getCells();		

		for (int i = 0; i < temp.length; i++) {
			Object changingThing = null;
							
			/*	
			 	Check to see if it is an edge or a vertex and get the appropriate changing
				 item. It is _imporant_ to check for edges first. This cost me a whole afternoon!
				DefaultEdge is a subclass of DefaultGraphCell, so if you check for that one first
				it will resolve true, but not perform as desired.
			*/
			if (temp[i] instanceof DefaultEdge) {																
				changingThing =
					_ourSketch.getAdapter().getEdgeFromCell(
						(DefaultEdge)temp[i]);
				
			} else if(temp[i] instanceof DefaultGraphCell){
				changingThing =
					_ourSketch.getAdapter().getVertexFromCell(
						(DefaultGraphCell) temp[i]);				
			}
			else{
				
			}
			
			
			
			// We always remove the existing item first, because the vector can contain
			// doubles if we simply add whenever the 'add' is selected. If something is 
			// selected, and is selected again, it will be added again. So we remove first.
			// if the expectation was that it be removed, then it won't be added again later.
			_currentSelection.remove(changingThing);
			if (graphEvent.isAddedCell(i) && !(changingThing instanceof GuideEdge)) {
				_currentSelection.add(changingThing);			
			}
		}
		
		Easik.getInstance().getStateManager().selectionUpdated();
		
		if(_currentSelection.size() == 1){
			if(_currentSelection.get(0) instanceof EntityNode){
				EntityNode myEntity = (EntityNode)_currentSelection.get(0);
				DefaultMutableTreeNode myNode = myEntity.getNode();
				if(myNode == null)
					return;
				TreeNode[] myNodes = myNode.getPath();
				if(myNodes == null)
					return;
				TreePath myPath = new TreePath(myNodes);
				Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().scrollPathToVisible(myPath);
				Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().setSelectionPath(myPath);
			}
			else if(_currentSelection.get(0) instanceof Constraint){
				Constraint myConst = (Constraint)_currentSelection.get(0);
				DefaultMutableTreeNode myNode = myConst.getNode();
				if(myNode == null)
					return;
				TreeNode[] myNodes = myNode.getPath();
				if(myNodes == null)
					return;
				TreePath myPath = new TreePath(myNodes);
				Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().scrollPathToVisible(myPath);
				Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().setSelectionPath(myPath);
			}
		}
	}	

}
